// content.js

window.addEventListener("message", (event) => {
  if (event.source !== window || !event.data || !event.data.action) return;
  if (event.data.action === 'setKazpatentFlag') {
    chrome.storage.local.set({ kazpatent_from_easywork: true }, function() {
      window.postMessage({ action: 'kazpatentFlagSet' }, '*');
    });
    return;
  }
  if (event.data.action.includes("Response")) return;
  console.log("content.js received message:", event.data);
  chrome.runtime.sendMessage(event.data, (response) => {
    console.log("content.js received response from background:", response);
    if (response !== undefined) {
      window.postMessage(response, "*");
    }
  });
});
